import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;

/**
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public interface IServer  extends Remote {
	
	/**
	 * Metodo per ottenere il nome univoco del server
	 * @return stringa con il nome univoco del server
	 */
	public String getName()throws RemoteException;
	
	/**
	 * Metodo che permette al nuovo servitore di registrarsi 
	 * @param server_ref il riferimento al client
	 * @param reg informazioni del registro a cui il richiedente si vuole poi legare
	 * @throws RemoteException
	 */
	public void bindService(IServer server_ref,RegistryInfo reg)throws RemoteException;
	
	/**
	 * Metodo che permette al servotore di newsgroup di uscire dal gruppo
	 * @param server_ref riferimento al client
	 * @return true se la cancellazione  andata a buon fine, false altrimenti
	 * @throws RemoteException
	 */
	public boolean unbindService(INewsgroupServer server_ref,RegistryInfo reg)throws RemoteException;
	
	
	/**
	 * Metodo che serve per comunicare al server successivo nel ring l'entrata
	 * di un nuovo elemento server in coda al ring
	 * @param server_ref riferimento al server che fa la comunicazione
	 * @param as Vettore contenente i server attivi nel ring
	 */
	public void insertNewServer(IServer server_ref, Vector as)throws RemoteException;
	
	/**
	 * Metodo per comunicare agli altri server attivi la rimozione di un server
	 * dal ring
	 * @param ringEl numero di elementi del ring prima della rimozione
	 * @param remEl numero dell'elemento del ring che deve essere rimosso
	 * @throws RemoteException
	 */
	public void removeServer(int ringEl, int remEl)throws RemoteException;
	
	/**
	 * Metodo per comunicare agli altri server del ring l'aggiunta di un nuovo 
	 * messaggio in bacheca, in modo da rendere il tutto consistente. La comunicazione
	 * viene fatta all'elemento successivo del ring e si incarica questo di 
	 * comunicarlo poi al proprio successivo. 
	 * @param mess nuovo messaggio, quello che deve essere inserito.
	 * @param father eventuale messaggio di cui mess  risposta, se
	 * 		mess non era una risposta father  a null
	 * @param firstServName nome univoco del server che ha iniziato la transmit.
	 * 			Serve per il controllo di terminazione del transmit nel ring
	 */
	public void transmitMsg(Msg mess,Msg father,String firstServName)throws RemoteException;
	
	/**
	 * Metodo che serve per ottenere l'autorizzazione a cambiare qualcosa all'interno del ring
	 * Solo un processo server alla volta pu ottenere in un dato istante l'autorizzazione.
	 * Il metodo viene chiamato a manao a mano lungo tutto il ring 
	 * @param s Server che richiede l'autorizzazione ad effettuare un cambiamento in mutua esclusione
	 * @return true se il server ottiene l'autorizzazione, false altrimenti
	 * @throws RemoteException
	 */
	public boolean changeRing(IServer s)throws RemoteException;
	
	/**
	 * Metodo che serve per liberare il ring dopo che si  fatto un cambiamento,
	 * in modo che se anche altri server devono ottenere l'autorizzazione per un cambiamento
	 * all'interno del ring possano ottenere risposta affermativa
	 * @param s server che ha cambiato qualcosa all'interno del ring e che rilascia il "token"
	 * @throws RemoteException
	 */
	public void changeRingDone(IServer s)throws RemoteException;

}
